#include "scripts.h"
void ScriptRegistrar::UnregisterScript(ScriptFactory *ptr)
{
	ScriptFactory *x = mScriptFactories;
	ScriptFactory *z = 0;
	ScriptFactory *y;
	if (x == 0)
	{
		return;
	}
	do
	{
		y = x->GetNext();
		if (x != ptr)
		{
			if (z == 0)
			{
				mScriptFactories = y;
			}
			else
			{
				z->SetNext(y);
			}
		}
		z = x;
		x = y;				
	} while (y != 0);
}

ScriptFactory *ScriptRegistrar::mScriptFactories;
void ScriptRegistrar::RegisterScript(ScriptFactory *ptr)
{
	ptr->SetNext(mScriptFactories);
	mScriptFactories = ptr;
}
ScriptFactory* ScriptRegistrar::GetScriptFactory(const char *name) 
{
	ScriptFactory *x = mScriptFactories;
	do 	{
		if (stricmp(x->GetName(),name) == 0)
		{
			return x;
		}
		x = x->GetNext();
	} while (x != NULL);
	return 0;
}
ScriptFactory* ScriptRegistrar::GetScriptFactory(int number) 
{
	ScriptFactory *x = mScriptFactories;
	int n = 0;
	do
	{
		if (n == number)
		{
			return x;
		}
		x = x->GetNext();
		n++;
	} while (x != NULL);
	return 0;
}
int ScriptRegistrar::Count() 
{
	ScriptFactory *x;
	int sn = 0;
	x = mScriptFactories;
	while (x != 0)
	{
		sn++;
		x = x->GetNext();
	}
	return sn;
}
ScriptImpClass *ScriptRegistrar::CreateScript(const char *name) 
{
	ScriptFactory *x = mScriptFactories;
	do
	{
		if (stricmp(x->GetName(),name) == 0)
		{
			return x->Create();
		}
		x = x->GetNext();
	} while (x != NULL);
	return 0;
}
